/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static void extract(InputStream is, File outputFolder) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        byte[] buffer = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            File outputFile = new File(outputFolder.getCanonicalPath() + File.separatorChar + entry.getName());
            File outputParent = new File(outputFile.getParent());
            outputParent.mkdirs();
            if (entry.isDirectory()) {
                if (outputFile.exists()) continue;
                outputFile.mkdir();
                continue;
            }
            FileOutputStream fos = new FileOutputStream(outputFile);
            Throwable throwable = null;
            try {
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fos == null) continue;
                if (throwable != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }
}

