/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app.configuration;

import java.io.File;
import org.jbake.app.FileUtil;
import org.jbake.app.JBakeException;
import org.jbake.app.configuration.JBakeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBakeConfigurationInspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JBakeConfigurationInspector.class);
    private final JBakeConfiguration configuration;

    public JBakeConfigurationInspector(JBakeConfiguration configuration) {
        this.configuration = configuration;
    }

    public void inspect() throws JBakeException {
        this.ensureSource();
        this.ensureTemplateFolder();
        this.ensureContentFolder();
        this.ensureDestination();
        this.checkAssetFolder();
    }

    private void ensureSource() throws JBakeException {
        File source = this.configuration.getSourceFolder();
        if (!FileUtil.isExistingFolder(source)) {
            throw new JBakeException("Error: Source folder must exist: " + source.getAbsolutePath());
        }
        if (!this.configuration.getSourceFolder().canRead()) {
            throw new JBakeException("Error: Source folder is not readable: " + source.getAbsolutePath());
        }
    }

    private void ensureTemplateFolder() {
        File path = this.configuration.getTemplateFolder();
        this.checkRequiredFolderExists(this.configuration.getTemplateFolderName(), path);
    }

    private void ensureContentFolder() {
        File path = this.configuration.getContentFolder();
        this.checkRequiredFolderExists(this.configuration.getContentFolderName(), path);
    }

    private void ensureDestination() {
        File destination = this.configuration.getDestinationFolder();
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (!destination.canWrite()) {
            throw new JBakeException("Error: Destination folder is not writable: " + destination.getAbsolutePath());
        }
    }

    private void checkAssetFolder() {
        File path = this.configuration.getAssetFolder();
        if (!path.exists()) {
            LOGGER.warn("No asset folder '{}' was found!", (Object)path.getAbsolutePath());
        }
    }

    private void checkRequiredFolderExists(String folderName, File path) {
        if (!FileUtil.isExistingFolder(path)) {
            throw new JBakeException("Error: Required folder cannot be found! Expected to find [" + folderName + "] at: " + path.getAbsolutePath());
        }
    }
}

