/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ZipUtil;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;

public class Init {
    private JBakeConfiguration config;

    @Deprecated
    public Init(CompositeConfiguration config) {
        this(new DefaultJBakeConfiguration(config));
    }

    public Init(JBakeConfiguration config) {
        this.config = config;
    }

    public void run(File outputFolder, File templateLocationFolder, String templateType) throws Exception {
        File templateFile;
        if (!outputFolder.canWrite()) {
            throw new Exception("Output folder is not writeable!");
        }
        File[] contents = outputFolder.listFiles();
        boolean safe = true;
        if (contents != null) {
            for (File content : contents) {
                if (!content.isDirectory()) continue;
                if (content.getName().equalsIgnoreCase(this.config.getTemplateFolderName())) {
                    safe = false;
                }
                if (content.getName().equalsIgnoreCase(this.config.getContentFolderName())) {
                    safe = false;
                }
                if (!content.getName().equalsIgnoreCase(this.config.getAssetFolderName())) continue;
                safe = false;
            }
        }
        if (!safe) {
            throw new Exception(String.format("Output folder '%s' already contains structure!", outputFolder.getAbsolutePath()));
        }
        if (this.config.getExampleProjectByType(templateType) != null) {
            templateFile = new File(templateLocationFolder, this.config.getExampleProjectByType(templateType));
            if (!templateFile.exists()) {
                throw new Exception("Cannot find example project file: " + templateFile.getPath());
            }
        } else {
            throw new Exception("Cannot locate example project type: " + templateType);
        }
        ZipUtil.extract(new FileInputStream(templateFile), outputFolder);
    }
}

