/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbake.app.configuration.JBakeConfiguration;

public class ParserContext {
    private final File file;
    private final List<String> fileLines;
    private final JBakeConfiguration config;
    private final boolean hasHeader;
    private final Map<String, Object> documentModel;

    public ParserContext(File file, List<String> fileLines, JBakeConfiguration config, boolean hasHeader) {
        this.file = file;
        this.fileLines = fileLines;
        this.config = config;
        this.hasHeader = hasHeader;
        this.documentModel = new HashMap<String, Object>();
    }

    public File getFile() {
        return this.file;
    }

    public List<String> getFileLines() {
        return this.fileLines;
    }

    public JBakeConfiguration getConfig() {
        return this.config;
    }

    public Map<String, Object> getDocumentModel() {
        return this.documentModel;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public String getBody() {
        return this.documentModel.get("body").toString();
    }

    public void setBody(String str) {
        this.documentModel.put("body", str);
    }

    public Object getDate() {
        return this.getDocumentModel().get("date");
    }

    public void setDate(Date date) {
        this.getDocumentModel().put("date", date);
    }

    public String getStatus() {
        if (this.getDocumentModel().containsKey("status")) {
            return this.getDocumentModel().get("status").toString();
        }
        return "";
    }

    public void setDefaultStatus() {
        this.getDocumentModel().put("status", this.getConfig().getDefaultStatus());
    }

    public String getType() {
        if (this.getDocumentModel().containsKey("type")) {
            return this.getDocumentModel().get("type").toString();
        }
        return "";
    }

    public void setDefaultType() {
        this.getDocumentModel().put("type", this.getConfig().getDefaultType());
    }

    public Object getTags() {
        return this.getDocumentModel().get("tags");
    }

    public void setTags(String[] tags) {
        this.getDocumentModel().put("tags", tags);
    }
}

