/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OInstanceofCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OIdentifier right;
    protected String rightString;

    public OInstanceofCondition(int id) {
        super(id);
    }

    public OInstanceofCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        if (currentRecord == null) {
            return false;
        }
        Object record = currentRecord.getRecord();
        if (record == null) {
            return false;
        }
        if (!(record instanceof ODocument)) {
            return false;
        }
        ODocument doc = (ODocument)record;
        OClass clazz = doc.getSchemaClass();
        if (clazz == null) {
            return false;
        }
        if (this.right != null) {
            return clazz.isSubClassOf(this.right.getStringValue());
        }
        if (this.rightString != null) {
            return clazz.isSubClassOf(this.decode(this.rightString));
        }
        return false;
    }

    private String decode(String rightString) {
        if (rightString == null) {
            return null;
        }
        return OStringSerializerHelper.decode(rightString.substring(1, rightString.length() - 1));
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" instanceof ");
        if (this.right != null) {
            this.right.toString(params, builder);
        } else if (this.rightString != null) {
            builder.append(this.rightString);
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        return this.left.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        if (!this.left.supportsBasicCalculation()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        if (!this.left.supportsBasicCalculation()) {
            return Collections.singletonList(this.left);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
    }
}

