/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OMatchExpression;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.PatternNode;
import java.util.LinkedHashMap;
import java.util.Map;

class Pattern {
    Map<String, PatternNode> aliasToNode = new LinkedHashMap<String, PatternNode>();
    int numOfEdges = 0;

    Pattern() {
    }

    void addExpression(OMatchExpression expression) {
        PatternNode originNode = this.getOrCreateNode(expression.origin);
        for (OMatchPathItem item : expression.items) {
            String nextAlias = item.filter.getAlias();
            PatternNode nextNode = this.getOrCreateNode(item.filter);
            this.numOfEdges += originNode.addEdge(item, nextNode);
            originNode = nextNode;
        }
    }

    private PatternNode getOrCreateNode(OMatchFilter origin) {
        PatternNode originNode = this.get(origin.getAlias());
        if (originNode == null) {
            originNode = new PatternNode();
            originNode.alias = origin.getAlias();
            this.aliasToNode.put(originNode.alias, originNode);
        }
        if (origin.isOptional()) {
            originNode.optional = true;
        }
        return originNode;
    }

    PatternNode get(String alias) {
        return this.aliasToNode.get(alias);
    }

    int getNumOfEdges() {
        return this.numOfEdges;
    }

    public void validate() {
        for (PatternNode node : this.aliasToNode.values()) {
            if (!node.isOptionalNode()) continue;
            if (node.out.size() > 0) {
                throw new OCommandSQLParsingException("In current MATCH version, optional nodes are allowed only on right terminal nodes, eg. {} --> {optional:true} is allowed, {optional:true} <-- {} is not. ");
            }
            if (node.in.size() != 0) continue;
            throw new OCommandSQLParsingException("In current MATCH version, optional nodes must have at least one incoming pattern edge");
        }
    }
}

